import { StyleSheet } from "react-native";
import dpr from "../Utilities/CustomStyleAttribute/dpr";

const styles = StyleSheet.create({
    container: {
        backgroundColor: "#fff",
        paddingHorizontal: dpr(20),
    },
    banner: {
        marginTop: dpr(15),
        marginBottom: dpr(24),
        borderRadius: 10,
        overflow: "hidden",
    },
    bannerImg: {
        height: dpr(180),
        width: "100%",
    },
    indicator: {
        backgroundColor: "#FCCA19",
        top: dpr(35) * 1.09,
        borderRadius: 32,
        width: "50%",
        height: 3,
        zIndex: 5,
    },
    slideContainer: {
        paddingVertical: 7,
        flexDirection: "row",
        justifyContent: "space-around",
        borderBottomColor: "#DFDFDF",
        borderBottomWidth: 1,
        zIndex: -5,
    },
    slideItem: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        textAlign: "center",
        color: "#2C2C2C",
    },
    color: (tab, text) => ({
        color: tab === text ? '#2C2C2C' : '#898989',
    }),
    slideScreen: {
        paddingVertical: dpr(16),
    },
});

export default styles;
